//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.12

import wesual.Ui 1.0
import wesual.Ui.Private 1.0

UiDialog {
    id : colorDialog

    property color color : "gray"

    label : qsTrId("d24f43407f34f770")

    contentDelegate : Item {
        implicitWidth : colorEditor.implicitWidth + 30
        implicitHeight : colorEditor.implicitHeight + 30

        UiColorEditor {
            id : colorEditor

            x : 15
            y : 15
            color : colorDialog.color

            onUpdateRequested : {
                colorDialog.color = newColor;
                colorDialog.result = newColor;
            }
        }
    }

    buttons : [
        UiDialogButton {
            role : UiDialogButton.OkRole
        },
        UiDialogButton {
            role : UiDialogButton.CancelRole
        }
    ]
}
